#ifndef LLF_PKI_RSA_KEY_GEN_DB_DEF_H
#define LLF_PKI_RSA_KEY_GEN_DB_DEF_H

/*
 * This file is #included in the middle of the struct declaration for CRYS_KGPrimeData_t
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_RSA_Types.h file !!!!
 *  2) only the CRYS_RSA_Types.h file should include this file. 
 */


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 09:23:41 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version LLF_RSA_pub_key_db_def.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


   struct
   {  
     union{
            struct{ 
                    /* Temporary buffers used for the exponent calculation need the maximum modolus size plus 
                       on block of 256 bits - used for vectores with the size of the modolous plus the public key */
                    DxUint32_t Tempbuff1[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff2[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff3[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff4[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff5[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                   
                  }NonCrt;
                  
            struct{ /* Temporary buffers used for the exponent calculation need the maximum modolus size plus 
                       on block of 256 bits - used for vectores with the size of the modolous plus the public key */
                    DxUint32_t Tempbuff1[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff2[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff3[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff4[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];
                    DxUint32_t Tempbuff5[CRYS_RSA_MAXIMUM_MOD_BUFFER_SIZE_IN_WORDS + (256/32)];        
                    
                  }Crt;
          
          }Data;
   }LLF;

#endif

